<?php

namespace App\Models\Accommodation;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Rating extends Model
{
    use HasFactory,SoftDeletes;

    protected $table = 'ac_rating';

    public function translations()
    {
        return $this->hasMany(RatingTranslation::class, 'rating_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(RatingTranslation::class, 'rating_id')
            ->where('lang_id', app('lang_id'));
    }
}
