<?php

namespace App\Models\General;

use App\Models\Accounting\TreeAccounting;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class CompanyAccountMappings extends Model implements Auditable
{
    use AuditableTrait;

    protected $table = 'company_account_mappings';

    protected $fillable = [
        'company_id',
        'currency_id',
        'tree_account_id',
        'type',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'company_id',
        'currency_id',
        'tree_account_id',
        'type',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created_at',
        'updated_at',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'created',
        'updated',
        'deleted',
    ];

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function tree()
    {
        return $this->belongsTo(TreeAccounting::class, 'tree_account_id');
    }

    public function company()
    {
        return $this->belongsTo(Companies::class, 'company_id');
    }
}
