<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Model;

class ServicesTranslation extends Model
{
    protected $table = 'services_translation';

    protected $fillable = [
        'lang_id',
        'services_id',
        'title',
    ];

    public function service()
    {
        return $this->belongsTo(Service::class, 'services_id');
    }

    public function language()
    {
        return $this->belongsTo(\App\Models\Languages\Languages::class, 'lang_id');
    }

    public function getLang()
    {
        return $this->belongsTo(\App\Models\Languages\Languages::class, 'lang_id');
    }

    public static function rules()
    {
        return [
            'lang_id' => 'required|integer|exists:languages,id',
            'services_id' => 'required|integer|exists:services,id',
            'title' => 'required|string|max:255',
        ];
    }

    public static function uniqueValidationRules($servicesId, $excludeId = null)
    {
        $rules = [
            'lang_id' => [
                'required',
                'integer',
                'exists:languages,id',
                function ($attribute, $value, $fail) use ($servicesId, $excludeId) {
                    $query = static::where('services_id', $servicesId)
                        ->where('lang_id', $value);

                    if ($excludeId) {
                        $query->where('id', '!=', $excludeId);
                    }

                    if ($query->exists()) {
                        $fail('This language is already translated for this service.');
                    }
                },
            ],
            'services_id' => 'required|integer|exists:services,id',
            'title' => 'required|string|max:255',
        ];

        return $rules;
    }
}
