<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class TaxRate extends Model implements Auditable
{
    protected $table = 'taxs_rate';

    use AuditableTrait, HasFactory, SoftDeletes;

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    protected $fillable = [
        'title',
        'percentage',
        'type',
        'is_active',
    ];

    protected $casts = [
        'percentage' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'title',
        'percentage',
        'type',
        'is_active',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function translations()
    {
        return $this->hasMany(TaxRateTranslation::class, 'tax_rate_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(TaxRateTranslation::class, 'tax_rate_id')
            ->where('lang_id', app('lang_id'));
    }

    public function accounting()
    {
        return $this->hasMany(TaxRateMappings::class, 'tax_rate_id')->with('currency', 'tree');
    }
}
