<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class WorkPeriod extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $table = 'ge_work_period';

    protected $fillable = [
        'period',
        'is_active',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'period',
        'is_active',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created_at',
        'updated_at',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function translations()
    {
        return $this->hasMany(WorkPeriodTranslation::class, 'work_period_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(WorkPeriodTranslation::class, 'work_period_id')
            ->where('lang_id', app('lang_id'));
    }
}
