<?php

namespace App\sys\Repository\Accounting;

use App\Models\Accounting\UnpostedCollections;
use Illuminate\Support\Facades\DB;

class UnpostedCollectionsRepository
{
    private $unpostedCollections;

    public function __construct()
    {
        $this->unpostedCollections = new UnpostedCollections;
    }

    public function add($data)
    {
        $this->unpostedCollections->profile_id = $data['profile_id'];
        $this->unpostedCollections->currency_id = $data['currency_id'];
        $this->unpostedCollections->currency_rate = $data['currency_rate'];
        $this->unpostedCollections->date = $data['date'];
        $this->unpostedCollections->next_date = $data['next_date'] ?? null;
        $this->unpostedCollections->amount = $data['amount'] ?? 0;
        $this->unpostedCollections->pay_type_id = $data['pay_type_id'] ?? null;
        $this->unpostedCollections->transaction_amount = $data['transaction_amount'] ?? 0;
        $this->unpostedCollections->fee_amount = $data['fee_amount'] ?? 0;
        $this->unpostedCollections->reference = $data['reference'] ?? null;
        $this->unpostedCollections->details = $data['details'] ?? null;
        $this->unpostedCollections->customer_name = $data['customer_name'] ?? null;
        $this->unpostedCollections->save();

        return $this->unpostedCollections;
    }

    public function updated($data)
    {
        $post = $this->unpostedCollections->find($data['id']);
        $post->profile_id = $data['profile_id'] ?? $post->profile_id;
        $post->currency_id = $data['currency_id'] ?? $post->currency_id;
        $post->currency_rate = $data['currency_rate'] ?? $post->currency_rate;
        $post->date = $data['date'] ?? $post->date;
        $post->next_date = $data['next_date'] ?? $post->next_date;
        $post->amount = $data['amount'] ?? $post->amount;
        $post->pay_type_id = $data['pay_type_id'] ?? $post->pay_type_id;
        $post->transaction_amount = $data['transaction_amount'] ?? $post->transaction_amount;
        $post->fee_amount = $data['fee_amount'] ?? $post->fee_amount;
        $post->customer_name = $data['customer_name'] ?? $post->customer_name;
        $post->details = $data['details'] ?? $post->details;
        $post->reference = $data['reference'] ?? $post->reference;
        $post->is_posted = $data['is_posted'] ?? $post->is_posted;
        $post->posted_at = $data['posted_at'] ?? $post->posted_at;

        return $post->save();
    }

    public function getbyProfileID($profile_id)
    {
        return $this->unpostedCollections->with('currency', 'profile', 'paytype')->where('profile_id', $profile_id)->get();
    }

    public function getPostedByCurrnecy($profile_id)
    {
        return $this->unpostedCollections::select(
            'unposted_collections.currency_id',
            'currencies.name as currency_name',
            DB::raw('SUM(unposted_collections.amount) as total_amount')
        )
            ->join('currencies', 'currencies.id', '=', 'unposted_collections.currency_id')
            ->where('unposted_collections.profile_id', $profile_id)
            ->groupBy('unposted_collections.currency_id', 'currencies.name')
            ->get();
    }

    public function getAmountForCurrnecy($profile_id, $currency_id)
    {
        return $this->unpostedCollections->where([
            ['profile_id', $profile_id],
            ['currency_id', $currency_id],
        ])->sum('amount');
    }

    public function getAmountForCurrnecyIgonrId($id, $profile_id, $currency_id)
    {
        return $this->unpostedCollections->where([
            ['profile_id', $profile_id],
            ['currency_id', $currency_id],
        ])->where('id', '!=', $id)->sum('amount');
    }

    public function summary($profile_id)
    {
        return $this->unpostedCollections->summary($profile_id);
    }
}
