<?php

namespace App\sys\Repository\General;

use App\Models\General\CategoryTranslation;

class CategoryTranslationRepository
{
    private $categoryTranslation;

    public function __construct()
    {
        $this->categoryTranslation = new CategoryTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new CategoryTranslation;
        $rt->category_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->title = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->categoryTranslation->find($data['id']);
        $rt->title = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->categoryTranslation->with('getLang')->where('category_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->categoryTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
