<?php

namespace App\sys\Repository\General;

use App\Models\General\TransportationReasonTranslation;

class TransportationReasonTranslationRepository
{
    private $translation;

    public function __construct()
    {
        $this->translation = new TransportationReasonTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $tr = new TransportationReasonTranslation;
        $tr->transportation_id = $id;
        $tr->lang_id = $data['language_id'];
        $tr->name = $data['name'];
        $tr->save();
    }

    public function updated($data)
    {
        $tr = $this->translation->find($data['id']);
        $tr->name = $data['name'];
        $tr->save();
    }

    public function get($id)
    {
        return $this->translation->where('transportation_id', $id)->get();
    }

    public function del($id)
    {
        $tr = $this->translation->find($id);
        if ($tr) {
            return $tr->delete();
        }

        return false;
    }
}
