<?php

namespace App\sys\Repository\Profile;

use App\Models\Profile\AccommodationReservationPrices;

class AccommodationReservationPriceRepository
{
    public function getAll(array $filters = [])
    {
        $query = AccommodationReservationPrices::query();
        if (! empty($filters['reservation_id'])) {
            $query->where('reservation_id', $filters['reservation_id']);
        }
        if (! empty($filters['profile_id'])) {
            $query->where('profile_id', $filters['profile_id']);
        }
        if (! empty($filters['currency_id'])) {
            $query->where('currency_id', $filters['currency_id']);
        }

        return $query->get();
    }

    public function findByIdOrFail(int $id)
    {
        return AccommodationReservationPrices::find($id);
    }

    public function findByReservationProfileCurrency(int $reservationId, int $profileId, int $currencyId)
    {
        return AccommodationReservationPrices::where('reservation_id', $reservationId)
            ->where('profile_id', $profileId)
            ->where('currency_id', $currencyId)
            ->first();
    }

    public function create(array $data)
    {
        $item = new AccommodationReservationPrices;
        $item->reservation_id = $data['reservation_id'];
        $item->profile_id = $data['profile_id'];
        $item->currency_id = $data['currency_id'];
        $item->amount = $data['amount'] ?? 0;
        $item->tax = $data['tax'] ?? 0;
        $item->save();

        return $item;
    }

    public function incrementTotals(AccommodationReservationPrices $item, float $amountDelta, float $taxDelta)
    {
        $item->amount = ($item->amount ?? 0) + $amountDelta;
        $item->tax = ($item->tax ?? 0) + $taxDelta;
        $item->save();

        return $item;
    }
}
