<?php

namespace App\sys\Repository\Profile;

use App\Models\Profile\Attachment;

class AttachmentRepository
{
    public function upload(array $data)
    {
        $attachment = new Attachment;
        $attachment->profile_id = $data['profile_id'];
        $attachment->attachable_type = $data['attachable_type'];
        $attachment->attachable_id = $data['attachable_id'];
        $attachment->name = $data['name'] ?? null;
        // For constraints we don't store a custom name
        $attachment->path = $data['path'];
        $attachment->save();

        return $attachment;
    }

    public function deleteByIds(array $ids)
    {
        return Attachment::whereIn('id', $ids)->delete();
    }
}
