<?php

namespace App\sys\Services\Invoice\Types;

interface InvoiceTypeHandlerInterface
{
    /**
     * Extra validation rules to merge on create for this type
     */
    public function getCreateRules(array $request): array;

    /**
     * Extra validation rules to merge on update for this type (based on provided fields)
     */
    public function getUpdateRules(array $request): array;

    /**
     * Mutate request before persistence on create (compute fields, lookups, etc.)
     */
    public function prepareForCreate(array $request): array|false;

    /**
     * Mutate request before persistence on update (compute fields, lookups, etc.)
     */
    public function prepareForUpdate(array $request, object $existing): array|false;

    /**
     * Optional hook after create persistence
     */
    public function afterCreate(object $invoiceService, array $request): void;

    /**
     * Optional hook after update persistence
     */
    public function afterUpdate(object $invoiceService, array $request): void;
}
