<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int) $user->id === (int) $id;
});

// Private channel for user notifications
Broadcast::channel('user.{userId}', function ($user, $userId) {
    return (int) $user->id === (int) $userId;
});

// Private channel for group notifications
Broadcast::channel('group.{groupId}', function ($user, $groupId) {
    // التحقق من أن المستخدم في الـ group
    return $user->groups()->where('groups.id', $groupId)->exists();
});
