<?php

namespace App\Http\Controllers\Accounting;

use App\Http\Controllers\Controller;
use App\sys\ApiResponse;
use App\sys\Services\Accounting\UnpostedCollectionsServices;
use Illuminate\Http\Request;

class UnpostedCollectionsControllers extends Controller
{
    use ApiResponse;

    private $postsService;

    public function __construct()
    {
        $this->postsService = new UnpostedCollectionsServices;
    }

    public function getBypofile($id)
    {
        $data = $this->postsService->getByProfile($id);

        return $this->apiResponse(200, 'data by profile', null, $data);
    }

    public function add(Request $request)
    {
        if ($this->postsService->add($request->all())) {
            return $this->apiResponse(200, 'Add successfully', null, null);
        }

        $errors = $this->postsService->errors();

        return $this->apiResponse(400, 'faild', $errors, null);
    }

    public function update(Request $request)
    {
        if ($this->postsService->update($request->all())) {
            return $this->apiResponse(200, 'Updated successfully', null, null);
        }
        $errors = $this->postsService->errors();

        return $this->apiResponse(400, 'faild', $errors, null);
    }

    public function checkAmount(Request $request)
    {
        if ($data = $this->postsService->getAmount($request->all())) {
            return $this->apiResponse(200, 'Check amount', null, $data);
        }

        $errors = $this->postsService->errors();

        return $this->apiResponse(400, 'faild', $errors, null);
    }

    public function summary($id)
    {
        $data = $this->postsService->summary($id);

        return $this->apiResponse(200, 'data by profile', null, $data);
    }

    public function selectedCurrency($id)
    {
        $data = $this->postsService->selectedCurrency($id);

        return $this->apiResponse(200, 'Selected currency', null, $data);
    }
}
