<?php

namespace App\Http\Resources\General\Area;

use Illuminate\Http\Resources\Json\JsonResource;

class AreaLangResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'city_id' => $this->city_id,
            'active' => $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'translations' => ($this->translations && $this->translations->isNotEmpty())
                ? AreaTranslationResource::collection($this->translations)
                : null,
        ];
    }
}
