<?php

namespace App\Models\Accounting;

use Illuminate\Database\Eloquent\Model;

class TreeAccountingTranslation extends Model
{
    protected $table = 'tree_accounting_translation';

    protected $fillable = [
        'tree_accounting_id',
        'lang_id',
        'title',
        'description',
    ];

    public function tree()
    {
        return $this->belongsTo(TreeAccounting::class, 'tree_accounting_id');
    }

    public function getLang()
    {
        return $this->belongsTo(\App\Models\Languages\Languages::class, 'lang_id');
    }
}
