<?php

namespace App\Models\General;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class City extends Model implements Auditable
{
    use AuditableTrait, HasFactory, SoftDeletes;

    protected $table = 'cities';

    protected $fillable = [
        'country_id',
        'name',
        'short_cut',
        'is_active',
    ];

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'country_id',
        'name',
        'shortcut',
        'is_active',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created',
        'modified',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'updated',
    ];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function translations()
    {
        return $this->hasMany(CityTranslation::class, 'city_id');
    }

    public function currentTranslation()
    {
        return $this->hasOne(CityTranslation::class, 'city_id')
            ->where('lang_id', app('lang_id'));
    }
}
