<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory;

    protected $table = 'roles';

    protected $fillable = [
        'name',
        'description',
    ];

    public function users()
    {
        return $this->hasMany(User::class, 'role_id');
    }

    public function permissions()
    {
        return $this->belongsToMany(
            Permission::class,
            'role_has_permissions', // 1. اسم الجدول بتاعك بالظبط
            'role_id',
            'permission_id'
        )->withPivot('function_name', 'collection_name'); // 2. عشان يعرف يتعامل مع العمود الزيادة ده
    }
}
