<?php

namespace App\Models;

use App\Models\Accounting\TreeAccounting;
use App\Models\General\Currency;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class UserAccountMapping extends Model implements Auditable
{
    use AuditableTrait;

    protected $table = 'user_account_mappings';

    protected $fillable = [
        'user_id',
        'currency_id',
        'percentage',
        'commission_account_id',
        'wallet_account_id',
        'Supplier_account_id',
    ];

    /**
     * Attributes to audit
     */
    protected $auditInclude = [
        'user_id',
        'currency_id',
        'tree_account_id',
        'type',
    ];

    /**
     * Attributes to exclude from audit
     */
    protected $auditExclude = [
        'created_at',
        'updated_at',
    ];

    /**
     * Audit events to record
     */
    protected $auditEvents = [
        'created',
        'updated',
        'deleted',
    ];

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }

    public function commissionAccount()
    {
        return $this->belongsTo(TreeAccounting::class, 'commission_account_id');
    }

    public function walletAccount()
    {
        return $this->belongsTo(TreeAccounting::class, 'wallet_account_id');
    }

    public function supplierAccount()
    {
        return $this->belongsTo(TreeAccounting::class, 'Supplier_account_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
