<?php

namespace App\Models\invoice;

use Illuminate\Database\Eloquent\Model;

class AirlineTickets extends Model
{
    protected $table = 'airline_tickets';

    const CREATED_AT = 'created';

    const UPDATED_AT = 'modified';

    protected $fillable = [
        'company_id',
        'month',
        'invoice_service_id',
        'issue_date',
        'chair_num',
        'flight_num',
        'from_airline_id',
        'to_airline_id',
        'go_back',
        'from_airport_id',
        'to_airport_id',
        'ticket_num',
        'passport_num',
        'title',
        'economy_class',
        'passenger_type',
        'passenger_name',
        'ticket_emd',
        'emd_price',
        'fare_price',
        'tax',
        'earned_discount',
        'granted_discount',
        'total_price',
        'pnr',
        'note',
    ];

    protected $casts = [
        'issue_date' => 'datetime',
        'created' => 'datetime',
        'modified' => 'datetime',
        'emd_price' => 'double',
        'fare_price' => 'double',
        'tax' => 'double',
        'earned_discount' => 'double',
        'granted_discount' => 'double',
        'total_price' => 'double',
    ];

    public function invoiceService()
    {
        return $this->belongsTo(InvoiceServices::class, 'invoice_service_id');
    }

    public function company()
    {
        return $this->belongsTo(\App\Models\General\Companies::class, 'company_id');
    }

    public function fromAirport()
    {
        return $this->belongsTo(\App\Models\Airports::class, 'from_airport_id');
    }

    public function toAirport()
    {
        return $this->belongsTo(\App\Models\Airports::class, 'to_airport_id');
    }

    public function fromAirline()
    {
        return $this->belongsTo(\App\Models\Airline::class, 'from_airline_id');
    }

    public function toAirline()
    {
        return $this->belongsTo(\App\Models\Airline::class, 'to_airline_id');
    }
}
