<?php

namespace App\Models\invoice;

use Illuminate\Database\Eloquent\Model;

class Segments extends Model
{
    protected $table = 'segments';

    protected $fillable = [
        'invoice_services_id',
        'origin_airport',
        'destination_airport',
        'date',
        'time',
        'type',
        'flight_number',
        'flight_company',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    public function invoiceService()
    {
        return $this->belongsTo(InvoiceServices::class, 'invoice_services_id');
    }

    public function originAirport()
    {
        return $this->belongsTo(\App\Models\Airports::class, 'origin_airport');
    }

    public function destinationAirport()
    {
        return $this->belongsTo(\App\Models\Airports::class, 'destination_airport');
    }

    public function flightCompany()
    {
        return $this->belongsTo(\App\Models\Airline::class, 'flight_company');
    }
}
