<?php

namespace App\sys\Repository\Accommodation;

use App\Models\Accommodation\EXtrasTranslations;

class ExtraTranslationRepository
{
    private $extraTranslation;

    public function __construct()
    {
        $this->extraTranslation = new EXtrasTranslations;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $ex = new EXtrasTranslations;
        $ex->extras_id = $id;
        $ex->lang_id = $data['language_id'];
        $ex->name = $data['name'];
        $ex->save();
    }

    public function updated($data)
    {
        $ex = $this->extraTranslation->find($data['id']);
        $ex->name = $data['name'];
        $ex->save();
    }

    public function get($id)
    {
        return $this->extraTranslation->with('getLang')->where('extras_id', $id)->get();
    }

    public function del($id)
    {
        $ex = $this->extraTranslation->find($id);
        if ($ex) {
            return $ex->delete();
        }

        return false;
    }
}
