<?php

namespace App\sys\Repository\General;

use App\Models\General\GuideLanguageTranslation;

class GuideLanguageTranslationRepository
{
    private $model;

    public function __construct()
    {
        $this->model = new GuideLanguageTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new GuideLanguageTranslation;
        $rt->guide_language_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->name = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->model->find($data['id']);
        $rt->name = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->model->with('getLang')->where('guide_language_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->model->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
