<?php

namespace App\sys\Repository\General;

use App\Models\General\TaxRateTranslation;

class TaxRateTranslationRepository
{
    private $taxRateTranslation;

    public function __construct()
    {
        $this->taxRateTranslation = new TaxRateTranslation;
    }

    public function save($data, $id)
    {
        foreach ($data as $value) {
            if (isset($value['id']) && $value['id'] != null) {
                $this->updated($value);
            } else {
                $this->add($value, $id);
            }
        }

        return true;
    }

    public function add($data, $id)
    {
        $rt = new TaxRateTranslation;
        $rt->tax_rate_id = $id;
        $rt->lang_id = $data['language_id'];
        $rt->title = $data['name'];
        $rt->save();
    }

    public function updated($data)
    {
        $rt = $this->taxRateTranslation->find($data['id']);
        $rt->title = $data['name'];
        $rt->save();
    }

    public function get($id)
    {
        return $this->taxRateTranslation->with('getLang')->where('tax_rate_id', $id)->get();
    }

    public function del($id)
    {
        $rt = $this->taxRateTranslation->find($id);
        if ($rt) {
            return $rt->delete();
        }

        return false;
    }
}
