<?php

namespace App\sys\Services\Roles_Groups;

use App\sys\Repository\Roles_Groups\PermissionRepositery;
use App\sys\Services;
use Illuminate\Support\Facades\Validator;

class PermissionService extends Services
{
    protected $permissionRepository;

    public function __construct(PermissionRepositery $permissionRepository)
    {
        $this->permissionRepository = $permissionRepository;
    }

    public function getPaginated()
    {
        return $this->permissionRepository->getPaginated();
    }

    public function create($data)
    {
        $rules = [
            'permission_name' => 'required|string|unique:permissions|max:255',
            'Controller_name' => 'nullable|string|max:255',
            'collection_name' => 'nullable|string|max:255',
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->permissionRepository->add($data);
    }

    public function updatee(array $data, $id)
    {

        $rules = [
            'permission_name' => ['sometimes', 'string', 'unique:permissions,permission_name,'.$id, 'max:255'],
            'Controller_name' => 'nullable|string|max:255',
            'collection_name' => 'nullable|string|max:255',
        ];

        $validator = Validator::make($data, $rules);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }

        return $this->permissionRepository->updated($id, $data);
    }

    public function deletee($id)
    {

        return $this->permissionRepository->deletee($id);
    }

    public function get($id)
    {

        $validator = Validator::make(['id' => $id], [
            'id' => ['required', 'integer', 'exists:permissions,id'],
        ]);
        if ($validator->fails()) {
            $this->setError($validator->errors());

            return false;
        }
        $role = $this->permissionRepository->find($id);

        return $role;
    }

    public function getUserPermissionsGrouped($user)
    {

        $rolePermissions = $user->role ? $user->role->permissions : collect();

        $overrides = $user->overrides;

        $permissions = $rolePermissions->keyBy('id');

        foreach ($overrides as $override) {
            if ($override->pivot->override_type == 'deny') {

                $permissions->forget($override->id);
            } else {

                $permissions->put($override->id, $override);
            }
        }
        $grouped = $permissions->groupBy('controller_name')->map(function ($group, $key) {
            return [
                'key' => strtoupper($key),
                'permissions' => $group->pluck('permission_name')->values()->all(),
            ];
        })->values();

        return $grouped;
    }
}
